%
% H11.02
%
% min 0.5 x^T x
% s.t. x1+x2 = 1
%
clear
close all
clc

function [f,fGrad,fHess] = objFun(x)
    % [f,fGrad,fHess] = objFun(x)
    % 
    % Objective function 
    % 
    % INPUT:
    %   x
    %     [2,1]
    %     State-vector
    % OUTPUT    
    %   f
    %     scalar
    %     Objective-value
    %   fGrad
    %     [2,1]
    %     Gradient
    %   fHess
    %     [2,2]
    %     Hessian
    % 
    
    % ...
    % ...
        
end

function [c,cGrad,cHess] = constrFun(x)    
    % [c,cGrad,cHess] = constrFun(x)
    % 
    % Equality constraints
    % 
    % INPUT:
    %   x
    %     [2,1]
    %     State-vector
    % OUTPUT    
    %   c
    %     [m,1]
    %     Objective-value
    %   cGrad
    %     [2,m]
    %     Gradient
    %   cHess
    %     [2,2,m]
    %     Hessian
    % 
    
    % ...
    % ...
    
end
         
function [L,LGrad,LHess] = augLagFun(x,lambda,mu)
    % [L,LGrad,LHess] = augLagFun(x,lambda,mu)
    % 
    % Augmented Lagrangian 
    %
    %    L = f - c*lambda + (1/mu) * ||c||^2
    % 
    % INPUT:
    %   x
    %     [n,1]
    %     State-vector
    %   lambda
    %     [m,1]
    %   mu
    %     scalar
    %     Penalty-factor
    % OUTPUT
    %   L
    %     scalar
    %     Augmented Lagrangian function value
    %   LGrad
    %     [n,1]
    %     Gradient
    %   LHess
    %     [n,n]
    %     Hessian
    %
    
    [f,fGrad,fHess] = objFun(x);
    [c,cGrad,cHess] = constrFun(x);
    
     % ...
     % ...
     
end

function x = newtonOpt(fun,x0)
    % x = newtonOpt(fun,x0)
    % 
    % Newtons' method for solving the problem 
    %        min fun(x) 
    % by solving
    %        fGrad(x) = 0
    %
    % INPUT:
    %   fun
    %     function handle, [f,fGrad,fHess] = fun(x)
    %     Objective function 
    %   x0 
    %     [n,1]
    %     Initial guess
    % OUTPUT:
    %   x
    %     [n,1]
    %     Approximate solution 
    % 
    
    % ...
    % ...
    
end

function x = augLagOpt(x0,lambda0,mu0)
    % x = penaltyOpt(x0,lambda0,mu0)
    % 
    % Solve the problem  
    %    min f(x)
    %    s.t. c(x) = 0
    % using the Augmented Lagrangian method
    % 
    % INPUT:
    %   x0
    %     [n,1]
    %     Initial guess
    %   lambda0
    %     [m,1]
    %     Initial guess for the Lagrange Multipliers
    %   mu0
    %     scalar
    %     Initial penalty factor
    % OUTPUT:
    %   x
    %     [n,1]
    %     Solution
    %

    % ...
    % ...

end

%%%% ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ %%%%
%%%%                            Solve problem                               %%%%
%%%% ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ %%%%

x0 = [2;2];
lambda0 = 1;
mu0 = 10;

x = augLagOpt(x0,lambda0,mu0)

