%
% H09.01
%
% min 0.5 x^T x
% s.t. x1+x2 = 1
%
clear
close all
clc

function [f,fGrad,fHess] = objFun(x)
    % [f,fGrad,fHess] = objFun(x)
    % 
    % Objective function 
    % 
    % INPUT:
    %   x
    %     [2,1]
    %     State-vector
    % OUTPUT    
    %   f
    %     scalar
    %     Objective-value
    %   fGrad
    %     [2,1]
    %     Gradient
    %   fHess
    %     [2,2]
    %     Hessian
    % 
       
    % ...
    % ... 
    
end

function [c,cGrad,cHess] = constrFun(x)    
    % [c,cGrad,cHess] = constrFun(x)
    % 
    % Equality constraints
    % 
    % INPUT:
    %   x
    %     [2,1]
    %     State-vector
    % OUTPUT    
    %   c
    %     [m,1]
    %     Objective-value
    %   cGrad
    %     [2,m]
    %     Gradient
    %   cHess
    %     [2,2,m]
    %     Hessian
    % 
       
    % ...
    % ... 
    
end
         
function [p,pGrad,pHess] = penaltyFun(x,mu)
    % [p,pGrad,pHess] = penaltyFun(x,mu)
    % 
    % Penalty function 
    %
    %    p = f + (1/mu) * ||c||^2
    % 
    % INPUT:
    %   x
    %     [n,1]
    %     State-vector
    %   mu
    %     scalar
    %     Penalty-factor
    % OUTPUT
    %   p
    %     scalar
    %     Penalty function value
    %   pGrad
    %     [n,1]
    %     Gradient
    %   pHess
    %     [n,n]
    %     Hessian
    % 
    
    [f,fGrad,fHess] = objFun(x);
    [c,cGrad,cHess] = constrFun(x); 
    
    % ...
    % ... 
    
end

function x = newtonOpt(fun,x0)
    % x = newtonOpt(fun,x0)
    % 
    % Newtons' method for solving the problem 
    %        min fun(x) 
    % by solving
    %        fGrad(x) = 0
    %
    % INPUT:
    %   fun
    %     function handle, [f,fGrad,fHess] = fun(x)
    %     Objective function 
    %   x0 
    %     [n,1]
    %     Initial guess
    % OUTPUT:
    %   x
    %     [n,1]
    %     Approximate solution 
    % 

end

function x = penaltyOpt(x0,mu0)
    % x = penaltyOpt(x0)
    % 
    % Solve the problem  
    %    min f(x)
    %    s.t. c(x) = 0
    % using the penalty method
    % 
    % INPUT:
    %   x0
    %     [n,1]
    %     Initial guess
    %   mu0
    %     scalar
    %     Initial penalty factor
    % OUTPUT:
    %   x
    %     [n,1]
    %     Solution
    %

end

%%%% ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ %%%%
%%%%                             Main Script                                %%%%
%%%% ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ %%%%

x0 = [2;3];
mu0 = 1;

x = penaltyOpt(x0,mu0);


