function newton

createPlot(200);
z = [-.5;2];
zs = newtonIteration(z,100,.1);
# zs = newtonIteration(z,10,1);

z = [0.2;0];
zs = newtonIteration(z,10,1);
plotIterates(zs);

function [f,df,ddf] = rosenbrock(z)
  x = z(1);
  y = z(2);
  
  f =   100*(x^2-y)^2 + (x-1)^2;
  
  df =  [200*(x^2-y)*2*x+2*(x-1)   
         200*(y-x^2)];
         
  ddf = [400*((x^2-y)+2*x*x)+2     -400*x
         -400*x                     200 ];
         
function dz = newtonStep(z)
  [_,df,ddf] = rosenbrock(z);
  dz = ddf \ (-df);
  
function zs = newtonIteration(z,k,alpha)
  zs = zeros(2,k);
  zs(:,1) = z;
  for i=2:k
    dz = newtonStep(z);
    z = z + alpha*dz;
    zs(:,i) = z;
  end
  
function createPlot(n)
  [X,Y] = meshgrid( linspace(-2,2,n), linspace(-1.5,2.5,n));
  sizeMG = size(X);
  F = zeros(n,n);

  for i=1:n
    for j=1:n 
      F(i,j) = rosenbrock([X(i,j);Y(i,j)]);
    end
  end
  
  figure(1);
  clf
  contour(X,Y,F,linspace(1,500,40));
  hold on
  plot(1,1,'rx','linewidth',2);
  colorbar
  hold off

function plotIterates(zs)
  figure(1);
  hold on
  plot(zs(1,:),zs(2,:),'b-o','linewidth',2);
  
  figure(2);
  n = size(zs,2);
  es = zs - [1;1]*ones(1,n);
  es = sqrt(sum(es.^2,1));
  figure(2);
  semilogy(1:n,es,'b-o','linewidth',2);
  
